// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Monitor.Query.Models
{
    internal partial class MetricNamespaceCollection
    {
        internal static MetricNamespaceCollection DeserializeMetricNamespaceCollection(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<MetricNamespace> value = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("value"u8))
                {
                    List<MetricNamespace> array = new List<MetricNamespace>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MetricNamespace.DeserializeMetricNamespace(item));
                    }
                    value = array;
                    continue;
                }
            }
            return new MetricNamespaceCollection(value);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static MetricNamespaceCollection FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeMetricNamespaceCollection(document.RootElement);
        }
    }
}
