// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Monitor.Query.Models
{
    /// <summary> Kind of namespace. </summary>
    public readonly partial struct MetricNamespaceClassification : IEquatable<MetricNamespaceClassification>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MetricNamespaceClassification"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MetricNamespaceClassification(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PlatformValue = "Platform";
        private const string CustomValue = "Custom";
        private const string QualityOfServiceValue = "Qos";

        /// <summary> Platform. </summary>
        public static MetricNamespaceClassification Platform { get; } = new MetricNamespaceClassification(PlatformValue);
        /// <summary> Custom. </summary>
        public static MetricNamespaceClassification Custom { get; } = new MetricNamespaceClassification(CustomValue);
        /// <summary> Determines if two <see cref="MetricNamespaceClassification"/> values are the same. </summary>
        public static bool operator ==(MetricNamespaceClassification left, MetricNamespaceClassification right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MetricNamespaceClassification"/> values are not the same. </summary>
        public static bool operator !=(MetricNamespaceClassification left, MetricNamespaceClassification right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MetricNamespaceClassification"/>. </summary>
        public static implicit operator MetricNamespaceClassification(string value) => new MetricNamespaceClassification(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MetricNamespaceClassification other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MetricNamespaceClassification other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
