// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Monitor.Query.Models
{
    /// <summary> Metric definition class specifies the metadata for a metric. </summary>
    public partial class MetricDefinition
    {
        /// <summary> Initializes a new instance of <see cref="MetricDefinition"/>. </summary>
        internal MetricDefinition()
        {
            SupportedAggregationTypes = new ChangeTrackingList<MetricAggregationType>();
            MetricAvailabilities = new ChangeTrackingList<MetricAvailability>();
            LocalizedDimensions = new ChangeTrackingList<LocalizableString>();
        }

        /// <summary> Initializes a new instance of <see cref="MetricDefinition"/>. </summary>
        /// <param name="isDimensionRequired"> Flag to indicate whether the dimension is required. </param>
        /// <param name="resourceId"> The resource identifier of the resource that emitted the metric. </param>
        /// <param name="namespace"> The namespace the metric belongs to. </param>
        /// <param name="localizedName"> The name and the display name of the metric, i.e. it is a localizable string. </param>
        /// <param name="displayDescription"> Detailed description of this metric. </param>
        /// <param name="category"> Custom category name for this metric. </param>
        /// <param name="metricClass"> The class of the metric. </param>
        /// <param name="unit"> The unit of the metric. </param>
        /// <param name="primaryAggregationType"> The primary aggregation type value defining how to use the values for display. </param>
        /// <param name="supportedAggregationTypes"> The collection of what aggregation types are supported. </param>
        /// <param name="metricAvailabilities"> The collection of what aggregation intervals are available to be queried. </param>
        /// <param name="id"> The resource identifier of the metric definition. </param>
        /// <param name="localizedDimensions"> The name and the display name of the dimension, i.e. it is a localizable string. </param>
        internal MetricDefinition(bool? isDimensionRequired, string resourceId, string @namespace, LocalizableString localizedName, string displayDescription, string category, MetricClass? metricClass, MetricUnit? unit, MetricAggregationType? primaryAggregationType, IReadOnlyList<MetricAggregationType> supportedAggregationTypes, IReadOnlyList<MetricAvailability> metricAvailabilities, string id, IReadOnlyList<LocalizableString> localizedDimensions)
        {
            IsDimensionRequired = isDimensionRequired;
            ResourceId = resourceId;
            Namespace = @namespace;
            LocalizedName = localizedName;
            DisplayDescription = displayDescription;
            Category = category;
            MetricClass = metricClass;
            Unit = unit;
            PrimaryAggregationType = primaryAggregationType;
            SupportedAggregationTypes = supportedAggregationTypes;
            MetricAvailabilities = metricAvailabilities;
            Id = id;
            LocalizedDimensions = localizedDimensions;
        }

        /// <summary> Flag to indicate whether the dimension is required. </summary>
        public bool? IsDimensionRequired { get; }
        /// <summary> The resource identifier of the resource that emitted the metric. </summary>
        public string ResourceId { get; }
        /// <summary> The namespace the metric belongs to. </summary>
        public string Namespace { get; }
        /// <summary> Detailed description of this metric. </summary>
        public string DisplayDescription { get; }
        /// <summary> Custom category name for this metric. </summary>
        public string Category { get; }
        /// <summary> The class of the metric. </summary>
        public MetricClass? MetricClass { get; }
        /// <summary> The unit of the metric. </summary>
        public MetricUnit? Unit { get; }
        /// <summary> The primary aggregation type value defining how to use the values for display. </summary>
        public MetricAggregationType? PrimaryAggregationType { get; }
        /// <summary> The collection of what aggregation types are supported. </summary>
        public IReadOnlyList<MetricAggregationType> SupportedAggregationTypes { get; }
        /// <summary> The collection of what aggregation intervals are available to be queried. </summary>
        public IReadOnlyList<MetricAvailability> MetricAvailabilities { get; }
        /// <summary> The resource identifier of the metric definition. </summary>
        public string Id { get; }
    }
}
