// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Monitor.Query.Models
{
    public partial class MetricDefinition
    {
        internal static MetricDefinition DeserializeMetricDefinition(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? isDimensionRequired = default;
            string resourceId = default;
            string @namespace = default;
            LocalizableString name = default;
            string displayDescription = default;
            string category = default;
            MetricClass? metricClass = default;
            MetricUnit? unit = default;
            MetricAggregationType? primaryAggregationType = default;
            IReadOnlyList<MetricAggregationType> supportedAggregationTypes = default;
            IReadOnlyList<MetricAvailability> metricAvailabilities = default;
            string id = default;
            IReadOnlyList<LocalizableString> dimensions = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("isDimensionRequired"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isDimensionRequired = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("resourceId"u8))
                {
                    resourceId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("namespace"u8))
                {
                    @namespace = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    name = LocalizableString.DeserializeLocalizableString(property.Value);
                    continue;
                }
                if (property.NameEquals("displayDescription"u8))
                {
                    displayDescription = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("category"u8))
                {
                    category = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("metricClass"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    metricClass = new MetricClass(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("unit"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    unit = new MetricUnit(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("primaryAggregationType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    primaryAggregationType = property.Value.GetString().ToMetricAggregationType();
                    continue;
                }
                if (property.NameEquals("supportedAggregationTypes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MetricAggregationType> array = new List<MetricAggregationType>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString().ToMetricAggregationType());
                    }
                    supportedAggregationTypes = array;
                    continue;
                }
                if (property.NameEquals("metricAvailabilities"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MetricAvailability> array = new List<MetricAvailability>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MetricAvailability.DeserializeMetricAvailability(item));
                    }
                    metricAvailabilities = array;
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("dimensions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<LocalizableString> array = new List<LocalizableString>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(LocalizableString.DeserializeLocalizableString(item));
                    }
                    dimensions = array;
                    continue;
                }
            }
            return new MetricDefinition(
                isDimensionRequired,
                resourceId,
                @namespace,
                name,
                displayDescription,
                category,
                metricClass,
                unit,
                primaryAggregationType,
                supportedAggregationTypes ?? new ChangeTrackingList<MetricAggregationType>(),
                metricAvailabilities ?? new ChangeTrackingList<MetricAvailability>(),
                id,
                dimensions ?? new ChangeTrackingList<LocalizableString>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static MetricDefinition FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeMetricDefinition(document.RootElement);
        }
    }
}
