// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Monitor.Query.Models
{
    /// <summary> Metric availability specifies the time grain (aggregation interval or frequency) and the retention period for that time grain. </summary>
    public partial class MetricAvailability
    {
        /// <summary> Initializes a new instance of <see cref="MetricAvailability"/>. </summary>
        internal MetricAvailability()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MetricAvailability"/>. </summary>
        /// <param name="granularity"> The time grain specifies a supported aggregation interval for the metric. Expressed as a duration 'PT1M', 'P1D', etc. </param>
        /// <param name="retention"> The retention period for the metric at the specified timegrain.  Expressed as a duration 'PT1M', 'P1D', etc. </param>
        internal MetricAvailability(TimeSpan? granularity, TimeSpan? retention)
        {
            Granularity = granularity;
            Retention = retention;
        }
        /// <summary> The retention period for the metric at the specified timegrain.  Expressed as a duration 'PT1M', 'P1D', etc. </summary>
        public TimeSpan? Retention { get; }
    }
}
