// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Monitor.Query.Models
{
    internal static partial class MetricAggregationTypeExtensions
    {
        public static string ToSerialString(this MetricAggregationType value) => value switch
        {
            MetricAggregationType.None => "None",
            MetricAggregationType.Average => "Average",
            MetricAggregationType.Count => "Count",
            MetricAggregationType.Minimum => "Minimum",
            MetricAggregationType.Maximum => "Maximum",
            MetricAggregationType.Total => "Total",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown MetricAggregationType value.")
        };

        public static MetricAggregationType ToMetricAggregationType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "None")) return MetricAggregationType.None;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Average")) return MetricAggregationType.Average;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Count")) return MetricAggregationType.Count;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Minimum")) return MetricAggregationType.Minimum;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Maximum")) return MetricAggregationType.Maximum;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Total")) return MetricAggregationType.Total;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown MetricAggregationType value.");
        }
    }
}
