// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Monitor.Query.Models
{
    /// <summary> Log Analytics workspaces that were part of the metadata request and that the user has access to. </summary>
    internal partial class MetadataWorkspace
    {
        /// <summary> Initializes a new instance of <see cref="MetadataWorkspace"/>. </summary>
        /// <param name="id"> The ID of the Log Analytics workspace. </param>
        /// <param name="resourceId"> The ARM resource ID of the Log Analytics workspace. </param>
        /// <param name="name"> The name of the Log Analytics workspace. </param>
        /// <param name="region"> The Azure region of the Log Analytics workspace. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/>, <paramref name="resourceId"/>, <paramref name="name"/> or <paramref name="region"/> is null. </exception>
        internal MetadataWorkspace(string id, string resourceId, string name, string region)
        {
            Argument.AssertNotNull(id, nameof(id));
            Argument.AssertNotNull(resourceId, nameof(resourceId));
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(region, nameof(region));

            Id = id;
            ResourceId = resourceId;
            Name = name;
            Region = region;
        }

        /// <summary> Initializes a new instance of <see cref="MetadataWorkspace"/>. </summary>
        /// <param name="id"> The ID of the Log Analytics workspace. </param>
        /// <param name="resourceId"> The ARM resource ID of the Log Analytics workspace. </param>
        /// <param name="name"> The name of the Log Analytics workspace. </param>
        /// <param name="region"> The Azure region of the Log Analytics workspace. </param>
        /// <param name="related"> The related metadata items for the Log Analytics workspace. </param>
        internal MetadataWorkspace(string id, string resourceId, string name, string region, MetadataWorkspaceRelated related)
        {
            Id = id;
            ResourceId = resourceId;
            Name = name;
            Region = region;
            Related = related;
        }

        /// <summary> The ID of the Log Analytics workspace. </summary>
        public string Id { get; }
        /// <summary> The ARM resource ID of the Log Analytics workspace. </summary>
        public string ResourceId { get; }
        /// <summary> The name of the Log Analytics workspace. </summary>
        public string Name { get; }
        /// <summary> The Azure region of the Log Analytics workspace. </summary>
        public string Region { get; }
        /// <summary> The related metadata items for the Log Analytics workspace. </summary>
        public MetadataWorkspaceRelated Related { get; }
    }
}
