// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Monitor.Query.Models
{
    /// <summary> The related metadata items for the table. </summary>
    internal partial class MetadataTableRelated
    {
        /// <summary> Initializes a new instance of <see cref="MetadataTableRelated"/>. </summary>
        internal MetadataTableRelated()
        {
            Categories = new ChangeTrackingList<string>();
            Solutions = new ChangeTrackingList<string>();
            ResourceTypes = new ChangeTrackingList<string>();
            Workspaces = new ChangeTrackingList<string>();
            Functions = new ChangeTrackingList<string>();
            Queries = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="MetadataTableRelated"/>. </summary>
        /// <param name="categories"> The related categories for the table. </param>
        /// <param name="solutions"> The related Log Analytics solutions for the table. </param>
        /// <param name="resourceTypes"> The related resource types for the table. </param>
        /// <param name="workspaces"> The related Log Analytics workspaces for the table. </param>
        /// <param name="functions"> The related functions for the table. </param>
        /// <param name="queries"> The related saved queries for the table. </param>
        internal MetadataTableRelated(IReadOnlyList<string> categories, IReadOnlyList<string> solutions, IReadOnlyList<string> resourceTypes, IReadOnlyList<string> workspaces, IReadOnlyList<string> functions, IReadOnlyList<string> queries)
        {
            Categories = categories;
            Solutions = solutions;
            ResourceTypes = resourceTypes;
            Workspaces = workspaces;
            Functions = functions;
            Queries = queries;
        }

        /// <summary> The related categories for the table. </summary>
        public IReadOnlyList<string> Categories { get; }
        /// <summary> The related Log Analytics solutions for the table. </summary>
        public IReadOnlyList<string> Solutions { get; }
        /// <summary> The related resource types for the table. </summary>
        public IReadOnlyList<string> ResourceTypes { get; }
        /// <summary> The related Log Analytics workspaces for the table. </summary>
        public IReadOnlyList<string> Workspaces { get; }
        /// <summary> The related functions for the table. </summary>
        public IReadOnlyList<string> Functions { get; }
        /// <summary> The related saved queries for the table. </summary>
        public IReadOnlyList<string> Queries { get; }
    }
}
