// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Monitor.Query.Models
{
    /// <summary> The MetadataPermissionsResourcesItem. </summary>
    internal partial class MetadataPermissionsResourcesItem
    {
        /// <summary> Initializes a new instance of <see cref="MetadataPermissionsResourcesItem"/>. </summary>
        /// <param name="resourceId"> The resource ID on the permission indication. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceId"/> is null. </exception>
        internal MetadataPermissionsResourcesItem(string resourceId)
        {
            Argument.AssertNotNull(resourceId, nameof(resourceId));

            ResourceId = resourceId;
            DenyTables = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="MetadataPermissionsResourcesItem"/>. </summary>
        /// <param name="resourceId"> The resource ID on the permission indication. </param>
        /// <param name="denyTables"> The list of tables that were denied access for the resource ID. </param>
        internal MetadataPermissionsResourcesItem(string resourceId, IReadOnlyList<string> denyTables)
        {
            ResourceId = resourceId;
            DenyTables = denyTables;
        }

        /// <summary> The resource ID on the permission indication. </summary>
        public string ResourceId { get; }
        /// <summary> The list of tables that were denied access for the resource ID. </summary>
        public IReadOnlyList<string> DenyTables { get; }
    }
}
