// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Monitor.Query.Models
{
    /// <summary> Permission information for the metadata call, includes apps/workspaces/resource the user didn't have access to. </summary>
    internal partial class MetadataPermissions
    {
        /// <summary> Initializes a new instance of <see cref="MetadataPermissions"/>. </summary>
        /// <param name="workspaces"> The permission indication for the workspaces on the metadata request. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaces"/> is null. </exception>
        internal MetadataPermissions(IEnumerable<MetadataPermissionsWorkspacesItem> workspaces)
        {
            Argument.AssertNotNull(workspaces, nameof(workspaces));

            Workspaces = workspaces.ToList();
            Resources = new ChangeTrackingList<MetadataPermissionsResourcesItem>();
            Applications = new ChangeTrackingList<MetadataPermissionsApplicationsItem>();
        }

        /// <summary> Initializes a new instance of <see cref="MetadataPermissions"/>. </summary>
        /// <param name="workspaces"> The permission indication for the workspaces on the metadata request. </param>
        /// <param name="resources"> The permission indication for the Azure resources on the metadata request. </param>
        /// <param name="applications"> The permission indication for the Application Insights apps on the metadata request. </param>
        internal MetadataPermissions(IReadOnlyList<MetadataPermissionsWorkspacesItem> workspaces, IReadOnlyList<MetadataPermissionsResourcesItem> resources, IReadOnlyList<MetadataPermissionsApplicationsItem> applications)
        {
            Workspaces = workspaces;
            Resources = resources;
            Applications = applications;
        }

        /// <summary> The permission indication for the workspaces on the metadata request. </summary>
        public IReadOnlyList<MetadataPermissionsWorkspacesItem> Workspaces { get; }
        /// <summary> The permission indication for the Azure resources on the metadata request. </summary>
        public IReadOnlyList<MetadataPermissionsResourcesItem> Resources { get; }
        /// <summary> The permission indication for the Application Insights apps on the metadata request. </summary>
        public IReadOnlyList<MetadataPermissionsApplicationsItem> Applications { get; }
    }
}
