// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Monitor.Query.Models
{
    /// <summary> The related metadata items for the function. </summary>
    internal partial class MetadataFunctionRelated
    {
        /// <summary> Initializes a new instance of <see cref="MetadataFunctionRelated"/>. </summary>
        internal MetadataFunctionRelated()
        {
            Tables = new ChangeTrackingList<string>();
            Solutions = new ChangeTrackingList<string>();
            ResourceTypes = new ChangeTrackingList<string>();
            Categories = new ChangeTrackingList<string>();
            Workspaces = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="MetadataFunctionRelated"/>. </summary>
        /// <param name="tables"> The related tables for the function. </param>
        /// <param name="solutions"> The related Log Analytics solutions for the function. </param>
        /// <param name="resourceTypes"> The related resource types for the function. </param>
        /// <param name="categories"> The related categories for the function. </param>
        /// <param name="workspaces"> The related workspaces for the function. </param>
        internal MetadataFunctionRelated(IReadOnlyList<string> tables, IReadOnlyList<string> solutions, IReadOnlyList<string> resourceTypes, IReadOnlyList<string> categories, IReadOnlyList<string> workspaces)
        {
            Tables = tables;
            Solutions = solutions;
            ResourceTypes = resourceTypes;
            Categories = categories;
            Workspaces = workspaces;
        }

        /// <summary> The related tables for the function. </summary>
        public IReadOnlyList<string> Tables { get; }
        /// <summary> The related Log Analytics solutions for the function. </summary>
        public IReadOnlyList<string> Solutions { get; }
        /// <summary> The related resource types for the function. </summary>
        public IReadOnlyList<string> ResourceTypes { get; }
        /// <summary> The related categories for the function. </summary>
        public IReadOnlyList<string> Categories { get; }
        /// <summary> The related workspaces for the function. </summary>
        public IReadOnlyList<string> Workspaces { get; }
    }
}
