// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Monitor.Query.Models
{
    /// <summary> Functions are stored Kusto queries that can be specified as part of queries by using their name. </summary>
    internal partial class MetadataFunction
    {
        /// <summary> Initializes a new instance of <see cref="MetadataFunction"/>. </summary>
        /// <param name="id"> The ID of the function. </param>
        /// <param name="name"> The name of the function, to be used in queries. </param>
        /// <param name="body"> The KQL body of the function. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/>, <paramref name="name"/> or <paramref name="body"/> is null. </exception>
        internal MetadataFunction(string id, string name, string body)
        {
            Argument.AssertNotNull(id, nameof(id));
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(body, nameof(body));

            Id = id;
            Name = name;
            Body = body;
        }

        /// <summary> Initializes a new instance of <see cref="MetadataFunction"/>. </summary>
        /// <param name="id"> The ID of the function. </param>
        /// <param name="name"> The name of the function, to be used in queries. </param>
        /// <param name="parameters"> The parameters/arguments of the function, if any. </param>
        /// <param name="displayName"> The display name of the function. </param>
        /// <param name="description"> The description of the function. </param>
        /// <param name="body"> The KQL body of the function. </param>
        /// <param name="tags"> The tags associated with the function. </param>
        /// <param name="properties"> The properties of the function. </param>
        /// <param name="related"> The related metadata items for the function. </param>
        internal MetadataFunction(string id, string name, string parameters, string displayName, string description, string body, object tags, object properties, MetadataFunctionRelated related)
        {
            Id = id;
            Name = name;
            Parameters = parameters;
            DisplayName = displayName;
            Description = description;
            Body = body;
            Tags = tags;
            Properties = properties;
            Related = related;
        }

        /// <summary> The ID of the function. </summary>
        public string Id { get; }
        /// <summary> The name of the function, to be used in queries. </summary>
        public string Name { get; }
        /// <summary> The parameters/arguments of the function, if any. </summary>
        public string Parameters { get; }
        /// <summary> The display name of the function. </summary>
        public string DisplayName { get; }
        /// <summary> The description of the function. </summary>
        public string Description { get; }
        /// <summary> The KQL body of the function. </summary>
        public string Body { get; }
        /// <summary> The tags associated with the function. </summary>
        public object Tags { get; }
        /// <summary> The properties of the function. </summary>
        public object Properties { get; }
        /// <summary> The related metadata items for the function. </summary>
        public MetadataFunctionRelated Related { get; }
    }
}
