// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Monitor.Query.Models
{
    /// <summary> The related metadata items for the category. </summary>
    internal partial class MetadataCategoryRelated
    {
        /// <summary> Initializes a new instance of <see cref="MetadataCategoryRelated"/>. </summary>
        internal MetadataCategoryRelated()
        {
            Tables = new ChangeTrackingList<string>();
            Functions = new ChangeTrackingList<string>();
            ResourceTypes = new ChangeTrackingList<string>();
            Queries = new ChangeTrackingList<string>();
            Solutions = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="MetadataCategoryRelated"/>. </summary>
        /// <param name="tables"> The tables related to the category. </param>
        /// <param name="functions"> The functions related to the category. </param>
        /// <param name="resourceTypes"> The resource types related to the category. </param>
        /// <param name="queries"> The saved queries related to the category. </param>
        /// <param name="solutions"> The Log Analytics solutions related to the category. </param>
        internal MetadataCategoryRelated(IReadOnlyList<string> tables, IReadOnlyList<string> functions, IReadOnlyList<string> resourceTypes, IReadOnlyList<string> queries, IReadOnlyList<string> solutions)
        {
            Tables = tables;
            Functions = functions;
            ResourceTypes = resourceTypes;
            Queries = queries;
            Solutions = solutions;
        }

        /// <summary> The tables related to the category. </summary>
        public IReadOnlyList<string> Tables { get; }
        /// <summary> The functions related to the category. </summary>
        public IReadOnlyList<string> Functions { get; }
        /// <summary> The resource types related to the category. </summary>
        public IReadOnlyList<string> ResourceTypes { get; }
        /// <summary> The saved queries related to the category. </summary>
        public IReadOnlyList<string> Queries { get; }
        /// <summary> The Log Analytics solutions related to the category. </summary>
        public IReadOnlyList<string> Solutions { get; }
    }
}
