// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text.Json;

namespace Azure.Monitor.Query.Models
{
    /// <summary> Contains the columns and rows for one table in a query response. </summary>
    public partial class LogsTable
    {
        /// <summary> Initializes a new instance of <see cref="LogsTable"/>. </summary>
        /// <param name="name"> The name of the table. </param>
        /// <param name="columns"> The list of columns in this table. </param>
        /// <param name="internalRows"> The resulting rows from this query. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> or <paramref name="columns"/> is null. </exception>
        internal LogsTable(string name, IEnumerable<LogsTableColumn> columns, JsonElement internalRows)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(columns, nameof(columns));

            Name = name;
            Columns = columns.ToList();
            InternalRows = internalRows;
        }

        /// <summary> Initializes a new instance of <see cref="LogsTable"/>. </summary>
        /// <param name="name"> The name of the table. </param>
        /// <param name="columns"> The list of columns in this table. </param>
        /// <param name="internalRows"> The resulting rows from this query. </param>
        internal LogsTable(string name, IReadOnlyList<LogsTableColumn> columns, JsonElement internalRows)
        {
            Name = name;
            Columns = columns;
            InternalRows = internalRows;
        }

        /// <summary> The name of the table. </summary>
        public string Name { get; }
        /// <summary> The list of columns in this table. </summary>
        public IReadOnlyList<LogsTableColumn> Columns { get; }
    }
}
