// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Monitor.Query.Models
{
    public partial class LogsTable
    {
        internal static LogsTable DeserializeLogsTable(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            IReadOnlyList<LogsTableColumn> columns = default;
            JsonElement rows = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("columns"u8))
                {
                    List<LogsTableColumn> array = new List<LogsTableColumn>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(LogsTableColumn.DeserializeLogsTableColumn(item));
                    }
                    columns = array;
                    continue;
                }
                if (property.NameEquals("rows"u8))
                {
                    rows = property.Value.Clone();
                    continue;
                }
            }
            return new LogsTable(name, columns, rows);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static LogsTable FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeLogsTable(document.RootElement);
        }
    }
}
