// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Monitor.Query.Models
{
    public partial class LogsQueryResult
    {
        internal static LogsQueryResult DeserializeLogsQueryResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<LogsTable> tables = default;
            JsonElement statistics = default;
            JsonElement render = default;
            JsonElement error = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tables"u8))
                {
                    List<LogsTable> array = new List<LogsTable>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(LogsTable.DeserializeLogsTable(item));
                    }
                    tables = array;
                    continue;
                }
                if (property.NameEquals("statistics"u8))
                {
                    statistics = property.Value.Clone();
                    continue;
                }
                if (property.NameEquals("render"u8))
                {
                    render = property.Value.Clone();
                    continue;
                }
                if (property.NameEquals("error"u8))
                {
                    error = property.Value.Clone();
                    continue;
                }
            }
            return new LogsQueryResult(tables, statistics, render, error);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static LogsQueryResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeLogsQueryResult(document.RootElement);
        }
    }
}
