// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Monitor.Query.Models
{
    /// <summary> An array of requests. </summary>
    internal partial class BatchRequest
    {
        /// <summary> Initializes a new instance of <see cref="BatchRequest"/>. </summary>
        /// <param name="requests"> An single request in a batch. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="requests"/> is null. </exception>
        public BatchRequest(IEnumerable<BatchQueryRequest> requests)
        {
            Argument.AssertNotNull(requests, nameof(requests));

            Requests = requests.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="BatchRequest"/>. </summary>
        /// <param name="requests"> An single request in a batch. </param>
        internal BatchRequest(IList<BatchQueryRequest> requests)
        {
            Requests = requests;
        }

        /// <summary> An single request in a batch. </summary>
        public IList<BatchQueryRequest> Requests { get; }
    }
}
