// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.Monitor.Query.Models;

namespace Azure.Monitor.Query
{
    internal partial class MetricsBatchRestClient
    {
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> Initializes a new instance of MetricsBatchRestClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="endpoint"> The regional endpoint to use, for example https://eastus.metrics.monitor.azure.com. The region should match the region of the requested resources. For global resources, the region should be 'global'. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientDiagnostics"/>, <paramref name="pipeline"/> or <paramref name="endpoint"/> is null. </exception>
        public MetricsBatchRestClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, Uri endpoint)
        {
            ClientDiagnostics = clientDiagnostics ?? throw new ArgumentNullException(nameof(clientDiagnostics));
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? throw new ArgumentNullException(nameof(endpoint));
        }

        internal HttpMessage CreateBatchRequest(string subscriptionId, string metricnamespace, IEnumerable<string> metricnames, ResourceIdList batchRequest, string starttime, string endtime, TimeSpan? interval, string aggregation, int? top, string orderby, string filter, string rollupby)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/metrics:getBatch", false);
            if (starttime != null)
            {
                uri.AppendQuery("starttime", starttime, true);
            }
            if (endtime != null)
            {
                uri.AppendQuery("endtime", endtime, true);
            }
            if (interval != null)
            {
                uri.AppendQuery("interval", interval.Value, "P", true);
            }
            uri.AppendQuery("metricnamespace", metricnamespace, true);
            if (metricnames != null && !(metricnames is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("metricnames", metricnames, ",", true);
            }
            if (aggregation != null)
            {
                uri.AppendQuery("aggregation", aggregation, true);
            }
            if (top != null)
            {
                uri.AppendQuery("top", top.Value, true);
            }
            if (orderby != null)
            {
                uri.AppendQuery("orderby", orderby, true);
            }
            if (filter != null)
            {
                uri.AppendQuery("filter", filter, true);
            }
            if (rollupby != null)
            {
                uri.AppendQuery("rollupby", rollupby, true);
            }
            uri.AppendQuery("api-version", "2023-10-01", true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(batchRequest);
            request.Content = content;
            return message;
        }

        /// <summary> Lists the metric values for multiple resources. </summary>
        /// <param name="subscriptionId"> The subscription identifier for the resources in this batch. </param>
        /// <param name="metricnamespace"> Metric namespace that contains the requested metric names. </param>
        /// <param name="metricnames"> The names of the metrics (comma separated) to retrieve. </param>
        /// <param name="batchRequest"> Metrics batch body including the list of resource ids. </param>
        /// <param name="starttime">
        /// The start time of the query. It is a string in the format 'yyyy-MM-ddTHH:mm:ss.fffZ'. If you have specified the endtime parameter, then this parameter is required.
        /// If only starttime is specified, then endtime defaults to the current time.
        /// If no time interval is specified, the default is 1 hour.
        /// </param>
        /// <param name="endtime"> The end time of the query. It is a string in the format 'yyyy-MM-ddTHH:mm:ss.fffZ'. </param>
        /// <param name="interval">
        /// The interval (i.e. timegrain) of the query in ISO 8601 duration format. Defaults to PT1M. Special case for 'FULL' value that returns single datapoint for entire time span requested.
        /// *Examples: PT15M, PT1H, P1D, FULL*
        /// </param>
        /// <param name="aggregation">
        /// The list of aggregation types (comma separated) to retrieve.
        /// *Examples: average, minimum, maximum*
        /// </param>
        /// <param name="top">
        /// The maximum number of records to retrieve per resource ID in the request.
        /// Valid only if filter is specified.
        /// Defaults to 10.
        /// </param>
        /// <param name="orderby">
        /// The aggregation to use for sorting results and the direction of the sort.
        /// Only one order can be specified.
        /// *Examples: sum asc*
        /// </param>
        /// <param name="filter"> The filter is used to reduce the set of metric data returned.&lt;br&gt;Example:&lt;br&gt;Metric contains metadata A, B and C.&lt;br&gt;- Return all time series of C where A = a1 and B = b1 or b2&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ or B eq ‘b2’ and C eq ‘*’**&lt;br&gt;- Invalid variant:&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘*’ or B = ‘b2’**&lt;br&gt;This is invalid because the logical or operator cannot separate two different metadata names.&lt;br&gt;- Return all time series where A = a1, B = b1 and C = c1:&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘c1’**&lt;br&gt;- Return all time series where A = a1&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘*’ and C eq ‘*’**. </param>
        /// <param name="rollupby"> Dimension name(s) to rollup results by. For example if you only want to see metric values with a filter like 'City eq Seattle or City eq Tacoma' but don't want to see separate values for each city, you can specify 'RollUpBy=City' to see the results for Seattle and Tacoma rolled up into one timeseries. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="metricnamespace"/>, <paramref name="metricnames"/> or <paramref name="batchRequest"/> is null. </exception>
        public async Task<Response<MetricsQueryResourcesResult>> BatchAsync(string subscriptionId, string metricnamespace, IEnumerable<string> metricnames, ResourceIdList batchRequest, string starttime = null, string endtime = null, TimeSpan? interval = null, string aggregation = null, int? top = null, string orderby = null, string filter = null, string rollupby = null, CancellationToken cancellationToken = default)
        {
            if (subscriptionId == null)
            {
                throw new ArgumentNullException(nameof(subscriptionId));
            }
            if (metricnamespace == null)
            {
                throw new ArgumentNullException(nameof(metricnamespace));
            }
            if (metricnames == null)
            {
                throw new ArgumentNullException(nameof(metricnames));
            }
            if (batchRequest == null)
            {
                throw new ArgumentNullException(nameof(batchRequest));
            }

            using var message = CreateBatchRequest(subscriptionId, metricnamespace, metricnames, batchRequest, starttime, endtime, interval, aggregation, top, orderby, filter, rollupby);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricsQueryResourcesResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = MetricsQueryResourcesResult.DeserializeMetricsQueryResourcesResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Lists the metric values for multiple resources. </summary>
        /// <param name="subscriptionId"> The subscription identifier for the resources in this batch. </param>
        /// <param name="metricnamespace"> Metric namespace that contains the requested metric names. </param>
        /// <param name="metricnames"> The names of the metrics (comma separated) to retrieve. </param>
        /// <param name="batchRequest"> Metrics batch body including the list of resource ids. </param>
        /// <param name="starttime">
        /// The start time of the query. It is a string in the format 'yyyy-MM-ddTHH:mm:ss.fffZ'. If you have specified the endtime parameter, then this parameter is required.
        /// If only starttime is specified, then endtime defaults to the current time.
        /// If no time interval is specified, the default is 1 hour.
        /// </param>
        /// <param name="endtime"> The end time of the query. It is a string in the format 'yyyy-MM-ddTHH:mm:ss.fffZ'. </param>
        /// <param name="interval">
        /// The interval (i.e. timegrain) of the query in ISO 8601 duration format. Defaults to PT1M. Special case for 'FULL' value that returns single datapoint for entire time span requested.
        /// *Examples: PT15M, PT1H, P1D, FULL*
        /// </param>
        /// <param name="aggregation">
        /// The list of aggregation types (comma separated) to retrieve.
        /// *Examples: average, minimum, maximum*
        /// </param>
        /// <param name="top">
        /// The maximum number of records to retrieve per resource ID in the request.
        /// Valid only if filter is specified.
        /// Defaults to 10.
        /// </param>
        /// <param name="orderby">
        /// The aggregation to use for sorting results and the direction of the sort.
        /// Only one order can be specified.
        /// *Examples: sum asc*
        /// </param>
        /// <param name="filter"> The filter is used to reduce the set of metric data returned.&lt;br&gt;Example:&lt;br&gt;Metric contains metadata A, B and C.&lt;br&gt;- Return all time series of C where A = a1 and B = b1 or b2&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ or B eq ‘b2’ and C eq ‘*’**&lt;br&gt;- Invalid variant:&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘*’ or B = ‘b2’**&lt;br&gt;This is invalid because the logical or operator cannot separate two different metadata names.&lt;br&gt;- Return all time series where A = a1, B = b1 and C = c1:&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘b1’ and C eq ‘c1’**&lt;br&gt;- Return all time series where A = a1&lt;br&gt;**filter=A eq ‘a1’ and B eq ‘*’ and C eq ‘*’**. </param>
        /// <param name="rollupby"> Dimension name(s) to rollup results by. For example if you only want to see metric values with a filter like 'City eq Seattle or City eq Tacoma' but don't want to see separate values for each city, you can specify 'RollUpBy=City' to see the results for Seattle and Tacoma rolled up into one timeseries. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="metricnamespace"/>, <paramref name="metricnames"/> or <paramref name="batchRequest"/> is null. </exception>
        public Response<MetricsQueryResourcesResult> Batch(string subscriptionId, string metricnamespace, IEnumerable<string> metricnames, ResourceIdList batchRequest, string starttime = null, string endtime = null, TimeSpan? interval = null, string aggregation = null, int? top = null, string orderby = null, string filter = null, string rollupby = null, CancellationToken cancellationToken = default)
        {
            if (subscriptionId == null)
            {
                throw new ArgumentNullException(nameof(subscriptionId));
            }
            if (metricnamespace == null)
            {
                throw new ArgumentNullException(nameof(metricnamespace));
            }
            if (metricnames == null)
            {
                throw new ArgumentNullException(nameof(metricnames));
            }
            if (batchRequest == null)
            {
                throw new ArgumentNullException(nameof(batchRequest));
            }

            using var message = CreateBatchRequest(subscriptionId, metricnamespace, metricnames, batchRequest, starttime, endtime, interval, aggregation, top, orderby, filter, rollupby);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        MetricsQueryResourcesResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = MetricsQueryResourcesResult.DeserializeMetricsQueryResourcesResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
