// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Monitor.OpenTelemetry.LiveMetrics.Models
{
    /// <summary> Telemetry type. </summary>
    internal readonly partial struct TelemetryType : IEquatable<TelemetryType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TelemetryType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TelemetryType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RequestValue = "Request";
        private const string DependencyValue = "Dependency";
        private const string ExceptionValue = "Exception";
        private const string EventValue = "Event";
        private const string MetricValue = "Metric";
        private const string PerformanceCounterValue = "PerformanceCounter";
        private const string TraceValue = "Trace";

        /// <summary> Represents a request telemetry type. </summary>
        public static TelemetryType Request { get; } = new TelemetryType(RequestValue);
        /// <summary> Represents a dependency telemetry type. </summary>
        public static TelemetryType Dependency { get; } = new TelemetryType(DependencyValue);
        /// <summary> Represents an exception telemetry type. </summary>
        public static TelemetryType Exception { get; } = new TelemetryType(ExceptionValue);
        /// <summary> Represents an event telemetry type. </summary>
        public static TelemetryType Event { get; } = new TelemetryType(EventValue);
        /// <summary> Represents a metric telemetry type. </summary>
        public static TelemetryType Metric { get; } = new TelemetryType(MetricValue);
        /// <summary> Represents a performance counter telemetry type. </summary>
        public static TelemetryType PerformanceCounter { get; } = new TelemetryType(PerformanceCounterValue);
        /// <summary> Represents a trace telemetry type. </summary>
        public static TelemetryType Trace { get; } = new TelemetryType(TraceValue);
        /// <summary> Determines if two <see cref="TelemetryType"/> values are the same. </summary>
        public static bool operator ==(TelemetryType left, TelemetryType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TelemetryType"/> values are not the same. </summary>
        public static bool operator !=(TelemetryType left, TelemetryType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TelemetryType"/>. </summary>
        public static implicit operator TelemetryType(string value) => new TelemetryType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TelemetryType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TelemetryType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
