// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Monitor.OpenTelemetry.LiveMetrics.Models
{
    /// <summary> Optional http response body, whose existence carries additional error descriptions. </summary>
    internal partial class ServiceError
    {
        /// <summary> Initializes a new instance of <see cref="ServiceError"/>. </summary>
        /// <param name="requestId"> A globally unique identifier to identify the diagnostic context. It defaults to the empty GUID. </param>
        /// <param name="responseDateTime"> Service error response date time. </param>
        /// <param name="code"> Error code. </param>
        /// <param name="message"> Error message. </param>
        /// <param name="exception"> Message of the exception that triggers the error response. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="requestId"/>, <paramref name="responseDateTime"/>, <paramref name="code"/>, <paramref name="message"/> or <paramref name="exception"/> is null. </exception>
        internal ServiceError(string requestId, string responseDateTime, string code, string message, string exception)
        {
            Argument.AssertNotNull(requestId, nameof(requestId));
            Argument.AssertNotNull(responseDateTime, nameof(responseDateTime));
            Argument.AssertNotNull(code, nameof(code));
            Argument.AssertNotNull(message, nameof(message));
            Argument.AssertNotNull(exception, nameof(exception));

            RequestId = requestId;
            ResponseDateTime = responseDateTime;
            Code = code;
            Message = message;
            Exception = exception;
        }

        /// <summary> A globally unique identifier to identify the diagnostic context. It defaults to the empty GUID. </summary>
        public string RequestId { get; }
        /// <summary> Service error response date time. </summary>
        public string ResponseDateTime { get; }
        /// <summary> Error code. </summary>
        public string Code { get; }
        /// <summary> Error message. </summary>
        public string Message { get; }
        /// <summary> Message of the exception that triggers the error response. </summary>
        public string Exception { get; }
    }
}
