// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Monitor.OpenTelemetry.LiveMetrics.Models
{
    internal partial class ServiceError
    {
        internal static ServiceError DeserializeServiceError(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string requestId = default;
            string responseDateTime = default;
            string code = default;
            string message = default;
            string exception = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("RequestId"u8))
                {
                    requestId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("ResponseDateTime"u8))
                {
                    responseDateTime = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("Code"u8))
                {
                    code = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("Message"u8))
                {
                    message = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("Exception"u8))
                {
                    exception = property.Value.GetString();
                    continue;
                }
            }
            return new ServiceError(requestId, responseDateTime, code, message, exception);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ServiceError FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeServiceError(document.RootElement);
        }
    }
}
