// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Monitor.OpenTelemetry.LiveMetrics.Models
{
    /// <summary> Controls document quotas to be sent to Live Metrics. </summary>
    internal partial class QuotaConfigurationInfo
    {
        /// <summary> Initializes a new instance of <see cref="QuotaConfigurationInfo"/>. </summary>
        /// <param name="maxQuota"> Max quota. </param>
        /// <param name="quotaAccrualRatePerSec"> Quota accrual rate per second. </param>
        internal QuotaConfigurationInfo(float maxQuota, float quotaAccrualRatePerSec)
        {
            MaxQuota = maxQuota;
            QuotaAccrualRatePerSec = quotaAccrualRatePerSec;
        }

        /// <summary> Initializes a new instance of <see cref="QuotaConfigurationInfo"/>. </summary>
        /// <param name="initialQuota"> Initial quota. </param>
        /// <param name="maxQuota"> Max quota. </param>
        /// <param name="quotaAccrualRatePerSec"> Quota accrual rate per second. </param>
        internal QuotaConfigurationInfo(float? initialQuota, float maxQuota, float quotaAccrualRatePerSec)
        {
            InitialQuota = initialQuota;
            MaxQuota = maxQuota;
            QuotaAccrualRatePerSec = quotaAccrualRatePerSec;
        }

        /// <summary> Initial quota. </summary>
        public float? InitialQuota { get; }
        /// <summary> Max quota. </summary>
        public float MaxQuota { get; }
        /// <summary> Quota accrual rate per second. </summary>
        public float QuotaAccrualRatePerSec { get; }
    }
}
