// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Monitor.OpenTelemetry.LiveMetrics.Models
{
    /// <summary> CPU consumption datapoint. </summary>
    internal partial class ProcessCpuData
    {
        /// <summary> Initializes a new instance of <see cref="ProcessCpuData"/>. </summary>
        /// <param name="processName"> Process name. </param>
        /// <param name="cpuPercentage"> CPU consumption percentage. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="processName"/> is null. </exception>
        public ProcessCpuData(string processName, int cpuPercentage)
        {
            Argument.AssertNotNull(processName, nameof(processName));

            ProcessName = processName;
            CpuPercentage = cpuPercentage;
        }

        /// <summary> Process name. </summary>
        public string ProcessName { get; }
        /// <summary> CPU consumption percentage. </summary>
        public int CpuPercentage { get; }
    }
}
