// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Monitor.OpenTelemetry.LiveMetrics.Models
{
    /// <summary> Enum representing the different types of predicates. </summary>
    internal readonly partial struct PredicateType : IEquatable<PredicateType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PredicateType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PredicateType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EqualValue = "Equal";
        private const string NotEqualValue = "NotEqual";
        private const string LessThanValue = "LessThan";
        private const string GreaterThanValue = "GreaterThan";
        private const string LessThanOrEqualValue = "LessThanOrEqual";
        private const string GreaterThanOrEqualValue = "GreaterThanOrEqual";
        private const string ContainsValue = "Contains";
        private const string DoesNotContainValue = "DoesNotContain";

        /// <summary> Represents an equality predicate. </summary>
        public static PredicateType Equal { get; } = new PredicateType(EqualValue);
        /// <summary> Represents a not-equal predicate. </summary>
        public static PredicateType NotEqual { get; } = new PredicateType(NotEqualValue);
        /// <summary> Represents a less-than predicate. </summary>
        public static PredicateType LessThan { get; } = new PredicateType(LessThanValue);
        /// <summary> Represents a greater-than predicate. </summary>
        public static PredicateType GreaterThan { get; } = new PredicateType(GreaterThanValue);
        /// <summary> Represents a less-than-or-equal predicate. </summary>
        public static PredicateType LessThanOrEqual { get; } = new PredicateType(LessThanOrEqualValue);
        /// <summary> Represents a greater-than-or-equal predicate. </summary>
        public static PredicateType GreaterThanOrEqual { get; } = new PredicateType(GreaterThanOrEqualValue);
        /// <summary> Represents a contains predicate. </summary>
        public static PredicateType Contains { get; } = new PredicateType(ContainsValue);
        /// <summary> Represents a does-not-contain predicate. </summary>
        public static PredicateType DoesNotContain { get; } = new PredicateType(DoesNotContainValue);
        /// <summary> Determines if two <see cref="PredicateType"/> values are the same. </summary>
        public static bool operator ==(PredicateType left, PredicateType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PredicateType"/> values are not the same. </summary>
        public static bool operator !=(PredicateType left, PredicateType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PredicateType"/>. </summary>
        public static implicit operator PredicateType(string value) => new PredicateType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PredicateType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PredicateType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
