// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Monitor.OpenTelemetry.LiveMetrics.Models
{
    /// <summary> Monitoring data point coming from the client, which includes metrics, documents and other metadata info. </summary>
    internal partial class MonitoringDataPoint
    {
        /// <summary> Initializes a new instance of <see cref="MonitoringDataPoint"/>. </summary>
        /// <param name="version"> Application Insights SDK version. </param>
        /// <param name="invariantVersion"> Version/generation of the data contract (MonitoringDataPoint) between SDK and Live Metrics. </param>
        /// <param name="instance"> Service instance name where Application Insights SDK lives. </param>
        /// <param name="roleName"> Service role name. </param>
        /// <param name="machineName"> Computer name where Application Insights SDK lives. </param>
        /// <param name="streamId"> Identifies an Application Insights SDK as a trusted agent to report metrics and documents. </param>
        /// <param name="isWebApp"> True if the current application is an Azure Web App. </param>
        /// <param name="performanceCollectionSupported"> True if performance counters collection is supported. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="version"/>, <paramref name="instance"/>, <paramref name="roleName"/>, <paramref name="machineName"/> or <paramref name="streamId"/> is null. </exception>
        public MonitoringDataPoint(string version, int invariantVersion, string instance, string roleName, string machineName, string streamId, bool isWebApp, bool performanceCollectionSupported)
        {
            Argument.AssertNotNull(version, nameof(version));
            Argument.AssertNotNull(instance, nameof(instance));
            Argument.AssertNotNull(roleName, nameof(roleName));
            Argument.AssertNotNull(machineName, nameof(machineName));
            Argument.AssertNotNull(streamId, nameof(streamId));

            Version = version;
            InvariantVersion = invariantVersion;
            Instance = instance;
            RoleName = roleName;
            MachineName = machineName;
            StreamId = streamId;
            IsWebApp = isWebApp;
            PerformanceCollectionSupported = performanceCollectionSupported;
            Metrics = new ChangeTrackingList<MetricPoint>();
            Documents = new ChangeTrackingList<DocumentIngress>();
            TopCpuProcesses = new ChangeTrackingList<ProcessCpuData>();
            CollectionConfigurationErrors = new ChangeTrackingList<CollectionConfigurationError>();
        }

        /// <summary> Initializes a new instance of <see cref="MonitoringDataPoint"/>. </summary>
        /// <param name="version"> Application Insights SDK version. </param>
        /// <param name="invariantVersion"> Version/generation of the data contract (MonitoringDataPoint) between SDK and Live Metrics. </param>
        /// <param name="instance"> Service instance name where Application Insights SDK lives. </param>
        /// <param name="roleName"> Service role name. </param>
        /// <param name="machineName"> Computer name where Application Insights SDK lives. </param>
        /// <param name="streamId"> Identifies an Application Insights SDK as a trusted agent to report metrics and documents. </param>
        /// <param name="timestamp"> Data point generation timestamp. </param>
        /// <param name="transmissionTime"> Timestamp when the client transmits the metrics and documents to Live Metrics. </param>
        /// <param name="isWebApp"> True if the current application is an Azure Web App. </param>
        /// <param name="performanceCollectionSupported"> True if performance counters collection is supported. </param>
        /// <param name="metrics"> An array of metric data points. </param>
        /// <param name="documents">
        /// An array of documents of a specific type {Request}, {RemoteDependency}, {Exception}, {Event}, or {Trace}
        /// Please note <see cref="DocumentIngress"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Event"/>, <see cref="Exception"/>, <see cref="RemoteDependency"/>, <see cref="Request"/> and <see cref="Trace"/>.
        /// </param>
        /// <param name="topCpuProcesses"> An array of top cpu consumption data point. </param>
        /// <param name="collectionConfigurationErrors"> An array of error while SDK parses and applies the {CollectionConfigurationInfo} provided by Live Metrics. </param>
        internal MonitoringDataPoint(string version, int invariantVersion, string instance, string roleName, string machineName, string streamId, DateTimeOffset? timestamp, DateTimeOffset? transmissionTime, bool isWebApp, bool performanceCollectionSupported, IList<MetricPoint> metrics, IList<DocumentIngress> documents, IList<ProcessCpuData> topCpuProcesses, IList<CollectionConfigurationError> collectionConfigurationErrors)
        {
            Version = version;
            InvariantVersion = invariantVersion;
            Instance = instance;
            RoleName = roleName;
            MachineName = machineName;
            StreamId = streamId;
            Timestamp = timestamp;
            TransmissionTime = transmissionTime;
            IsWebApp = isWebApp;
            PerformanceCollectionSupported = performanceCollectionSupported;
            Metrics = metrics;
            Documents = documents;
            TopCpuProcesses = topCpuProcesses;
            CollectionConfigurationErrors = collectionConfigurationErrors;
        }

        /// <summary> Application Insights SDK version. </summary>
        public string Version { get; }
        /// <summary> Version/generation of the data contract (MonitoringDataPoint) between SDK and Live Metrics. </summary>
        public int InvariantVersion { get; }
        /// <summary> Service instance name where Application Insights SDK lives. </summary>
        public string Instance { get; }
        /// <summary> Service role name. </summary>
        public string RoleName { get; }
        /// <summary> Computer name where Application Insights SDK lives. </summary>
        public string MachineName { get; }
        /// <summary> Identifies an Application Insights SDK as a trusted agent to report metrics and documents. </summary>
        public string StreamId { get; }
        /// <summary> Data point generation timestamp. </summary>
        public DateTimeOffset? Timestamp { get; set; }
        /// <summary> Timestamp when the client transmits the metrics and documents to Live Metrics. </summary>
        public DateTimeOffset? TransmissionTime { get; set; }
        /// <summary> True if the current application is an Azure Web App. </summary>
        public bool IsWebApp { get; }
        /// <summary> True if performance counters collection is supported. </summary>
        public bool PerformanceCollectionSupported { get; }
        /// <summary> An array of metric data points. </summary>
        public IList<MetricPoint> Metrics { get; }
        /// <summary>
        /// An array of documents of a specific type {Request}, {RemoteDependency}, {Exception}, {Event}, or {Trace}
        /// Please note <see cref="DocumentIngress"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Event"/>, <see cref="Exception"/>, <see cref="RemoteDependency"/>, <see cref="Request"/> and <see cref="Trace"/>.
        /// </summary>
        public IList<DocumentIngress> Documents { get; }
        /// <summary> An array of top cpu consumption data point. </summary>
        public IList<ProcessCpuData> TopCpuProcesses { get; }
        /// <summary> An array of error while SDK parses and applies the {CollectionConfigurationInfo} provided by Live Metrics. </summary>
        public IList<CollectionConfigurationError> CollectionConfigurationErrors { get; }
    }
}
