// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Monitor.OpenTelemetry.LiveMetrics.Models
{
    /// <summary> Metric data point. </summary>
    internal partial class MetricPoint
    {
        /// <summary> Initializes a new instance of <see cref="MetricPoint"/>. </summary>
        /// <param name="name"> Metric name. </param>
        /// <param name="value"> Metric value. </param>
        /// <param name="weight"> Metric weight. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        public MetricPoint(string name, double value, int weight)
        {
            Argument.AssertNotNull(name, nameof(name));

            Name = name;
            Value = value;
            Weight = weight;
        }

        /// <summary> Metric name. </summary>
        public string Name { get; }
        /// <summary> Metric value. </summary>
        public double Value { get; }
        /// <summary> Metric weight. </summary>
        public int Weight { get; }
    }
}
