// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Monitor.OpenTelemetry.LiveMetrics.Models
{
    /// <summary> Key-value pair of string and string. </summary>
    internal partial class KeyValuePairString
    {
        /// <summary> Initializes a new instance of <see cref="KeyValuePairString"/>. </summary>
        /// <param name="key"> Key of the key-value pair. </param>
        /// <param name="value"> Value of the key-value pair. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="key"/> or <paramref name="value"/> is null. </exception>
        public KeyValuePairString(string key, string value)
        {
            Argument.AssertNotNull(key, nameof(key));
            Argument.AssertNotNull(value, nameof(value));

            Key = key;
            Value = value;
        }

        /// <summary> Key of the key-value pair. </summary>
        public string Key { get; }
        /// <summary> Value of the key-value pair. </summary>
        public string Value { get; }
    }
}
