// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Monitor.OpenTelemetry.LiveMetrics.Models
{
    /// <summary> Exception document type. </summary>
    internal partial class Exception : DocumentIngress
    {
        /// <summary> Initializes a new instance of <see cref="Exception"/>. </summary>
        public Exception()
        {
            DocumentType = DocumentType.Exception;
        }

        /// <summary> Initializes a new instance of <see cref="Exception"/>. </summary>
        /// <param name="documentType"> Telemetry type. Types not defined in enum will get replaced with a 'Unknown' type. </param>
        /// <param name="documentStreamIds"> An array of document streaming ids. Each id identifies a flow of documents customized by UX customers. </param>
        /// <param name="properties"> Collection of custom properties. </param>
        /// <param name="exceptionType"> Exception type name. </param>
        /// <param name="exceptionMessage"> Exception message. </param>
        internal Exception(DocumentType documentType, IList<string> documentStreamIds, IList<KeyValuePairString> properties, string exceptionType, string exceptionMessage) : base(documentType, documentStreamIds, properties)
        {
            ExceptionType = exceptionType;
            ExceptionMessage = exceptionMessage;
            DocumentType = documentType;
        }

        /// <summary> Exception type name. </summary>
        public string ExceptionType { get; set; }
        /// <summary> Exception message. </summary>
        public string ExceptionMessage { get; set; }
    }
}
