// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Monitor.OpenTelemetry.LiveMetrics.Models
{
    /// <summary> Represents an error while SDK parses and applies an instance of CollectionConfigurationInfo. </summary>
    internal partial class CollectionConfigurationError
    {
        /// <summary> Initializes a new instance of <see cref="CollectionConfigurationError"/>. </summary>
        /// <param name="collectionConfigurationErrorType"> Error type. </param>
        /// <param name="message"> Error message. </param>
        /// <param name="fullException"> Exception that led to the creation of the configuration error. </param>
        /// <param name="data"> Custom properties to add more information to the error. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="message"/>, <paramref name="fullException"/> or <paramref name="data"/> is null. </exception>
        public CollectionConfigurationError(CollectionConfigurationErrorType collectionConfigurationErrorType, string message, string fullException, IEnumerable<KeyValuePairString> data)
        {
            Argument.AssertNotNull(message, nameof(message));
            Argument.AssertNotNull(fullException, nameof(fullException));
            Argument.AssertNotNull(data, nameof(data));

            CollectionConfigurationErrorType = collectionConfigurationErrorType;
            Message = message;
            FullException = fullException;
            Data = data.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="CollectionConfigurationError"/>. </summary>
        /// <param name="collectionConfigurationErrorType"> Error type. </param>
        /// <param name="message"> Error message. </param>
        /// <param name="fullException"> Exception that led to the creation of the configuration error. </param>
        /// <param name="data"> Custom properties to add more information to the error. </param>
        internal CollectionConfigurationError(CollectionConfigurationErrorType collectionConfigurationErrorType, string message, string fullException, IList<KeyValuePairString> data)
        {
            CollectionConfigurationErrorType = collectionConfigurationErrorType;
            Message = message;
            FullException = fullException;
            Data = data;
        }

        /// <summary> Error type. </summary>
        public CollectionConfigurationErrorType CollectionConfigurationErrorType { get; }
        /// <summary> Error message. </summary>
        public string Message { get; }
        /// <summary> Exception that led to the creation of the configuration error. </summary>
        public string FullException { get; }
        /// <summary> Custom properties to add more information to the error. </summary>
        public IList<KeyValuePairString> Data { get; }
    }
}
