// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Monitor.OpenTelemetry.LiveMetrics.Models
{
    /// <summary> Aggregation type. </summary>
    internal readonly partial struct AggregationType : IEquatable<AggregationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AggregationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AggregationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AvgValue = "Avg";
        private const string SumValue = "Sum";
        private const string MinValue = "Min";
        private const string MaxValue = "Max";

        /// <summary> Average. </summary>
        public static AggregationType Avg { get; } = new AggregationType(AvgValue);
        /// <summary> Sum. </summary>
        public static AggregationType Sum { get; } = new AggregationType(SumValue);
        /// <summary> Minimum. </summary>
        public static AggregationType Min { get; } = new AggregationType(MinValue);
        /// <summary> Maximum. </summary>
        public static AggregationType Max { get; } = new AggregationType(MaxValue);
        /// <summary> Determines if two <see cref="AggregationType"/> values are the same. </summary>
        public static bool operator ==(AggregationType left, AggregationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AggregationType"/> values are not the same. </summary>
        public static bool operator !=(AggregationType left, AggregationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AggregationType"/>. </summary>
        public static implicit operator AggregationType(string value) => new AggregationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AggregationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AggregationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
