// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Monitor.OpenTelemetry.Exporter.Models
{
    internal partial class TrackResponse
    {
        internal static TrackResponse DeserializeTrackResponse(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? itemsReceived = default;
            int? itemsAccepted = default;
            IReadOnlyList<TelemetryErrorDetails> errors = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("itemsReceived"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    itemsReceived = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("itemsAccepted"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    itemsAccepted = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("errors"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<TelemetryErrorDetails> array = new List<TelemetryErrorDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(TelemetryErrorDetails.DeserializeTelemetryErrorDetails(item));
                    }
                    errors = array;
                    continue;
                }
            }
            return new TrackResponse(itemsReceived, itemsAccepted, errors ?? new ChangeTrackingList<TelemetryErrorDetails>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static TrackResponse FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeTrackResponse(document.RootElement);
        }
    }
}
