// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.Monitor.OpenTelemetry.Exporter.Models
{
    internal partial class TelemetryExceptionDetails : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(Id))
            {
                writer.WritePropertyName("id"u8);
                writer.WriteNumberValue(Id.Value);
            }
            if (Optional.IsDefined(OuterId))
            {
                writer.WritePropertyName("outerId"u8);
                writer.WriteNumberValue(OuterId.Value);
            }
            if (Optional.IsDefined(TypeName))
            {
                writer.WritePropertyName("typeName"u8);
                writer.WriteStringValue(TypeName);
            }
            writer.WritePropertyName("message"u8);
            writer.WriteStringValue(Message);
            if (Optional.IsDefined(HasFullStack))
            {
                writer.WritePropertyName("hasFullStack"u8);
                writer.WriteBooleanValue(HasFullStack.Value);
            }
            if (Optional.IsDefined(Stack))
            {
                writer.WritePropertyName("stack"u8);
                writer.WriteStringValue(Stack);
            }
            if (Optional.IsCollectionDefined(ParsedStack))
            {
                writer.WritePropertyName("parsedStack"u8);
                writer.WriteStartArray();
                foreach (var item in ParsedStack)
                {
                    writer.WriteObjectValue(item);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
