// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Monitor.OpenTelemetry.Exporter.Models
{
    /// <summary> Stack frame information. </summary>
    internal partial class StackFrame
    {
        /// <summary> Initializes a new instance of <see cref="StackFrame"/>. </summary>
        /// <param name="level"></param>
        /// <param name="method"> Method name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="method"/> is null. </exception>
        public StackFrame(int level, string method)
        {
            Argument.AssertNotNull(method, nameof(method));

            Level = level;
            Method = method;
        }

        /// <summary> Initializes a new instance of <see cref="StackFrame"/>. </summary>
        /// <param name="level"></param>
        /// <param name="method"> Method name. </param>
        /// <param name="assembly"> Name of the assembly (dll, jar, etc.) containing this function. </param>
        /// <param name="fileName"> File name or URL of the method implementation. </param>
        /// <param name="line"> Line number of the code implementation. </param>
        internal StackFrame(int level, string method, string assembly, string fileName, int? line)
        {
            Level = level;
            Method = method;
            Assembly = assembly;
            FileName = fileName;
            Line = line;
        }

        /// <summary> Gets the level. </summary>
        public int Level { get; }
        /// <summary> Method name. </summary>
        public string Method { get; }
        /// <summary> Name of the assembly (dll, jar, etc.) containing this function. </summary>
        public string Assembly { get; set; }
        /// <summary> File name or URL of the method implementation. </summary>
        public string FileName { get; set; }
        /// <summary> Line number of the code implementation. </summary>
        public int? Line { get; set; }
    }
}
