// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Monitor.OpenTelemetry.Exporter.Models
{
    /// <summary> The abstract common base of all domains. </summary>
    internal partial class MonitorDomain
    {
        /// <summary> Initializes a new instance of <see cref="MonitorDomain"/>. </summary>
        /// <param name="version"> Schema version. </param>
        public MonitorDomain(int version)
        {
            Version = version;
            AdditionalProperties = new ChangeTrackingDictionary<string, object>();
        }

        /// <summary> Initializes a new instance of <see cref="MonitorDomain"/>. </summary>
        /// <param name="version"> Schema version. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal MonitorDomain(int version, IDictionary<string, object> additionalProperties)
        {
            Version = version;
            AdditionalProperties = additionalProperties;
        }

        /// <summary> Schema version. </summary>
        public int Version { get; }
        /// <summary> Additional Properties. </summary>
        public IDictionary<string, object> AdditionalProperties { get; }
    }
}
