// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.Monitor.OpenTelemetry.Exporter.Models
{
    internal partial class MetricDataPoint : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(Namespace))
            {
                writer.WritePropertyName("ns"u8);
                writer.WriteStringValue(Namespace);
            }
            writer.WritePropertyName("name"u8);
            writer.WriteStringValue(Name);
            if (Optional.IsDefined(DataPointType))
            {
                writer.WritePropertyName("kind"u8);
                writer.WriteStringValue(DataPointType.Value.ToString());
            }
            writer.WritePropertyName("value"u8);
            writer.WriteNumberValue(Value);
            if (Optional.IsDefined(Count))
            {
                if (Count != null)
                {
                    writer.WritePropertyName("count"u8);
                    writer.WriteNumberValue(Count.Value);
                }
                else
                {
                    writer.WriteNull("count");
                }
            }
            if (Optional.IsDefined(Min))
            {
                if (Min != null)
                {
                    writer.WritePropertyName("min"u8);
                    writer.WriteNumberValue(Min.Value);
                }
                else
                {
                    writer.WriteNull("min");
                }
            }
            if (Optional.IsDefined(Max))
            {
                if (Max != null)
                {
                    writer.WritePropertyName("max"u8);
                    writer.WriteNumberValue(Max.Value);
                }
                else
                {
                    writer.WriteNull("max");
                }
            }
            if (Optional.IsDefined(StdDev))
            {
                if (StdDev != null)
                {
                    writer.WritePropertyName("stdDev"u8);
                    writer.WriteNumberValue(StdDev.Value);
                }
                else
                {
                    writer.WriteNull("stdDev");
                }
            }
            writer.WriteEndObject();
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
