// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Monitor.OpenTelemetry.Exporter.Models
{
    /// <summary> Type of the metric data measurement. </summary>
    internal readonly partial struct DataPointType : IEquatable<DataPointType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataPointType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataPointType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MeasurementValue = "Measurement";
        private const string AggregationValue = "Aggregation";

        /// <summary> Measurement. </summary>
        public static DataPointType Measurement { get; } = new DataPointType(MeasurementValue);
        /// <summary> Aggregation. </summary>
        public static DataPointType Aggregation { get; } = new DataPointType(AggregationValue);
        /// <summary> Determines if two <see cref="DataPointType"/> values are the same. </summary>
        public static bool operator ==(DataPointType left, DataPointType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataPointType"/> values are not the same. </summary>
        public static bool operator !=(DataPointType left, DataPointType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataPointType"/>. </summary>
        public static implicit operator DataPointType(string value) => new DataPointType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataPointType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataPointType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
