// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Monitor.OpenTelemetry.AspNetCore.Models
{
    /// <summary> RemoteDependency document type. </summary>
    internal partial class RemoteDependency : DocumentIngress
    {
        /// <summary> Initializes a new instance of <see cref="RemoteDependency"/>. </summary>
        public RemoteDependency()
        {
            DocumentType = DocumentType.RemoteDependency;
        }

        /// <summary> Initializes a new instance of <see cref="RemoteDependency"/>. </summary>
        /// <param name="documentType"> Telemetry type. Types not defined in enum will get replaced with a 'Unknown' type. </param>
        /// <param name="documentStreamIds"> An array of document streaming ids. Each id identifies a flow of documents customized by UX customers. </param>
        /// <param name="properties"> Collection of custom properties. </param>
        /// <param name="name"> Name of the command initiated with this dependency call, e.g., GET /username. </param>
        /// <param name="commandName"> URL of the dependency call to the target, with all query string parameters. </param>
        /// <param name="resultCode"> Result code of a dependency call. Examples are SQL error code and HTTP status code. </param>
        /// <param name="duration"> Request duration in ISO 8601 duration format, i.e., P[n]Y[n]M[n]DT[n]H[n]M[n]S or P[n]W. </param>
        internal RemoteDependency(DocumentType documentType, IList<string> documentStreamIds, IList<KeyValuePairString> properties, string name, string commandName, string resultCode, string duration) : base(documentType, documentStreamIds, properties)
        {
            Name = name;
            CommandName = commandName;
            ResultCode = resultCode;
            Duration = duration;
            DocumentType = documentType;
        }

        /// <summary> Name of the command initiated with this dependency call, e.g., GET /username. </summary>
        public string Name { get; set; }
        /// <summary> URL of the dependency call to the target, with all query string parameters. </summary>
        public string CommandName { get; set; }
        /// <summary> Result code of a dependency call. Examples are SQL error code and HTTP status code. </summary>
        public string ResultCode { get; set; }
        /// <summary> Request duration in ISO 8601 duration format, i.e., P[n]Y[n]M[n]DT[n]H[n]M[n]S or P[n]W. </summary>
        public string Duration { get; set; }
    }
}
