// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.Monitor.OpenTelemetry.AspNetCore.Models
{
    internal partial class MonitoringDataPoint : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("Version"u8);
            writer.WriteStringValue(Version);
            writer.WritePropertyName("InvariantVersion"u8);
            writer.WriteNumberValue(InvariantVersion);
            writer.WritePropertyName("Instance"u8);
            writer.WriteStringValue(Instance);
            writer.WritePropertyName("RoleName"u8);
            writer.WriteStringValue(RoleName);
            writer.WritePropertyName("MachineName"u8);
            writer.WriteStringValue(MachineName);
            writer.WritePropertyName("StreamId"u8);
            writer.WriteStringValue(StreamId);
            if (Optional.IsDefined(Timestamp))
            {
                writer.WritePropertyName("Timestamp"u8);
                writer.WriteStringValue(Timestamp.Value, "O");
            }
            if (Optional.IsDefined(TransmissionTime))
            {
                writer.WritePropertyName("TransmissionTime"u8);
                writer.WriteStringValue(TransmissionTime.Value, "O");
            }
            writer.WritePropertyName("IsWebApp"u8);
            writer.WriteBooleanValue(IsWebApp);
            writer.WritePropertyName("PerformanceCollectionSupported"u8);
            writer.WriteBooleanValue(PerformanceCollectionSupported);
            if (Optional.IsCollectionDefined(Metrics))
            {
                writer.WritePropertyName("Metrics"u8);
                writer.WriteStartArray();
                foreach (var item in Metrics)
                {
                    writer.WriteObjectValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Documents))
            {
                writer.WritePropertyName("Documents"u8);
                writer.WriteStartArray();
                foreach (var item in Documents)
                {
                    writer.WriteObjectValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(TopCpuProcesses))
            {
                writer.WritePropertyName("TopCpuProcesses"u8);
                writer.WriteStartArray();
                foreach (var item in TopCpuProcesses)
                {
                    writer.WriteObjectValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(CollectionConfigurationErrors))
            {
                writer.WritePropertyName("CollectionConfigurationErrors"u8);
                writer.WriteStartArray();
                foreach (var item in CollectionConfigurationErrors)
                {
                    writer.WriteObjectValue(item);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
