// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Monitor.OpenTelemetry.AspNetCore.Models
{
    internal partial class FilterInfo
    {
        internal static FilterInfo DeserializeFilterInfo(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string fieldName = default;
            PredicateType predicate = default;
            string comparand = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("FieldName"u8))
                {
                    fieldName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("Predicate"u8))
                {
                    predicate = new PredicateType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("Comparand"u8))
                {
                    comparand = property.Value.GetString();
                    continue;
                }
            }
            return new FilterInfo(fieldName, predicate, comparand);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static FilterInfo FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeFilterInfo(document.RootElement);
        }
    }
}
