// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Monitor.OpenTelemetry.AspNetCore.Models
{
    /// <summary> Event document type. </summary>
    internal partial class Event : DocumentIngress
    {
        /// <summary> Initializes a new instance of <see cref="Event"/>. </summary>
        public Event()
        {
            DocumentType = DocumentType.Event;
        }

        /// <summary> Initializes a new instance of <see cref="Event"/>. </summary>
        /// <param name="documentType"> Telemetry type. Types not defined in enum will get replaced with a 'Unknown' type. </param>
        /// <param name="documentStreamIds"> An array of document streaming ids. Each id identifies a flow of documents customized by UX customers. </param>
        /// <param name="properties"> Collection of custom properties. </param>
        /// <param name="name"> Event name. </param>
        internal Event(DocumentType documentType, IList<string> documentStreamIds, IList<KeyValuePairString> properties, string name) : base(documentType, documentStreamIds, properties)
        {
            Name = name;
            DocumentType = documentType;
        }

        /// <summary> Event name. </summary>
        public string Name { get; set; }
    }
}
