// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Monitor.OpenTelemetry.AspNetCore.Models
{
    /// <summary> Configurations/filters set by UX to scope the document/telemetry it's interested in. </summary>
    internal partial class DocumentStreamInfo
    {
        /// <summary> Initializes a new instance of <see cref="DocumentStreamInfo"/>. </summary>
        /// <param name="id"> Identifier of the document stream initiated by a UX. </param>
        /// <param name="documentFilterGroups"> Gets or sets an OR-connected collection of filter groups. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> or <paramref name="documentFilterGroups"/> is null. </exception>
        internal DocumentStreamInfo(string id, IEnumerable<DocumentFilterConjunctionGroupInfo> documentFilterGroups)
        {
            Argument.AssertNotNull(id, nameof(id));
            Argument.AssertNotNull(documentFilterGroups, nameof(documentFilterGroups));

            Id = id;
            DocumentFilterGroups = documentFilterGroups.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="DocumentStreamInfo"/>. </summary>
        /// <param name="id"> Identifier of the document stream initiated by a UX. </param>
        /// <param name="documentFilterGroups"> Gets or sets an OR-connected collection of filter groups. </param>
        internal DocumentStreamInfo(string id, IReadOnlyList<DocumentFilterConjunctionGroupInfo> documentFilterGroups)
        {
            Id = id;
            DocumentFilterGroups = documentFilterGroups;
        }

        /// <summary> Identifier of the document stream initiated by a UX. </summary>
        public string Id { get; }
        /// <summary> Gets or sets an OR-connected collection of filter groups. </summary>
        public IReadOnlyList<DocumentFilterConjunctionGroupInfo> DocumentFilterGroups { get; }
    }
}
