// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Monitor.OpenTelemetry.AspNetCore.Models
{
    /// <summary>
    /// Base class of the specific document types.
    /// Please note <see cref="DocumentIngress"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="Event"/>, <see cref="Exception"/>, <see cref="RemoteDependency"/>, <see cref="Request"/> and <see cref="Trace"/>.
    /// </summary>
    internal abstract partial class DocumentIngress
    {
        /// <summary> Initializes a new instance of <see cref="DocumentIngress"/>. </summary>
        protected DocumentIngress()
        {
            DocumentStreamIds = new ChangeTrackingList<string>();
            Properties = new ChangeTrackingList<KeyValuePairString>();
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIngress"/>. </summary>
        /// <param name="documentType"> Telemetry type. Types not defined in enum will get replaced with a 'Unknown' type. </param>
        /// <param name="documentStreamIds"> An array of document streaming ids. Each id identifies a flow of documents customized by UX customers. </param>
        /// <param name="properties"> Collection of custom properties. </param>
        internal DocumentIngress(DocumentType documentType, IList<string> documentStreamIds, IList<KeyValuePairString> properties)
        {
            DocumentType = documentType;
            DocumentStreamIds = documentStreamIds;
            Properties = properties;
        }

        /// <summary> Telemetry type. Types not defined in enum will get replaced with a 'Unknown' type. </summary>
        internal DocumentType DocumentType { get; set; }
        /// <summary> An array of document streaming ids. Each id identifies a flow of documents customized by UX customers. </summary>
        public IList<string> DocumentStreamIds { get; }
        /// <summary> Collection of custom properties. </summary>
        public IList<KeyValuePairString> Properties { get; }
    }
}
