// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Monitor.OpenTelemetry.AspNetCore.Models
{
    internal partial class DocumentFilterConjunctionGroupInfo
    {
        internal static DocumentFilterConjunctionGroupInfo DeserializeDocumentFilterConjunctionGroupInfo(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            TelemetryType telemetryType = default;
            FilterConjunctionGroupInfo filters = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("TelemetryType"u8))
                {
                    telemetryType = new TelemetryType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("Filters"u8))
                {
                    filters = FilterConjunctionGroupInfo.DeserializeFilterConjunctionGroupInfo(property.Value);
                    continue;
                }
            }
            return new DocumentFilterConjunctionGroupInfo(telemetryType, filters);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static DocumentFilterConjunctionGroupInfo FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeDocumentFilterConjunctionGroupInfo(document.RootElement);
        }
    }
}
