// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Monitor.OpenTelemetry.AspNetCore.Models
{
    /// <summary> Collection configuration error type reported by the client SDK. </summary>
    internal readonly partial struct CollectionConfigurationErrorType : IEquatable<CollectionConfigurationErrorType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CollectionConfigurationErrorType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CollectionConfigurationErrorType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string PerformanceCounterParsingValue = "PerformanceCounterParsing";
        private const string PerformanceCounterUnexpectedValue = "PerformanceCounterUnexpected";
        private const string PerformanceCounterDuplicateIdsValue = "PerformanceCounterDuplicateIds";
        private const string DocumentStreamDuplicateIdsValue = "DocumentStreamDuplicateIds";
        private const string DocumentStreamFailureToCreateValue = "DocumentStreamFailureToCreate";
        private const string DocumentStreamFailureToCreateFilterUnexpectedValue = "DocumentStreamFailureToCreateFilterUnexpected";
        private const string MetricDuplicateIdsValue = "MetricDuplicateIds";
        private const string MetricTelemetryTypeUnsupportedValue = "MetricTelemetryTypeUnsupported";
        private const string MetricFailureToCreateValue = "MetricFailureToCreate";
        private const string MetricFailureToCreateFilterUnexpectedValue = "MetricFailureToCreateFilterUnexpected";
        private const string FilterFailureToCreateUnexpectedValue = "FilterFailureToCreateUnexpected";
        private const string CollectionConfigurationFailureToCreateUnexpectedValue = "CollectionConfigurationFailureToCreateUnexpected";

        /// <summary> Unknown error type. </summary>
        public static CollectionConfigurationErrorType Unknown { get; } = new CollectionConfigurationErrorType(UnknownValue);
        /// <summary> Performance counter parsing error. </summary>
        public static CollectionConfigurationErrorType PerformanceCounterParsing { get; } = new CollectionConfigurationErrorType(PerformanceCounterParsingValue);
        /// <summary> Performance counter unexpected error. </summary>
        public static CollectionConfigurationErrorType PerformanceCounterUnexpected { get; } = new CollectionConfigurationErrorType(PerformanceCounterUnexpectedValue);
        /// <summary> Performance counter duplicate ids. </summary>
        public static CollectionConfigurationErrorType PerformanceCounterDuplicateIds { get; } = new CollectionConfigurationErrorType(PerformanceCounterDuplicateIdsValue);
        /// <summary> Document stream duplication ids. </summary>
        public static CollectionConfigurationErrorType DocumentStreamDuplicateIds { get; } = new CollectionConfigurationErrorType(DocumentStreamDuplicateIdsValue);
        /// <summary> Document stream failed to create. </summary>
        public static CollectionConfigurationErrorType DocumentStreamFailureToCreate { get; } = new CollectionConfigurationErrorType(DocumentStreamFailureToCreateValue);
        /// <summary> Document stream failed to create filter unexpectedly. </summary>
        public static CollectionConfigurationErrorType DocumentStreamFailureToCreateFilterUnexpected { get; } = new CollectionConfigurationErrorType(DocumentStreamFailureToCreateFilterUnexpectedValue);
        /// <summary> Metric duplicate ids. </summary>
        public static CollectionConfigurationErrorType MetricDuplicateIds { get; } = new CollectionConfigurationErrorType(MetricDuplicateIdsValue);
        /// <summary> Metric telemetry type unsupported. </summary>
        public static CollectionConfigurationErrorType MetricTelemetryTypeUnsupported { get; } = new CollectionConfigurationErrorType(MetricTelemetryTypeUnsupportedValue);
        /// <summary> Metric failed to create. </summary>
        public static CollectionConfigurationErrorType MetricFailureToCreate { get; } = new CollectionConfigurationErrorType(MetricFailureToCreateValue);
        /// <summary> Metric failed to create filter unexpectedly. </summary>
        public static CollectionConfigurationErrorType MetricFailureToCreateFilterUnexpected { get; } = new CollectionConfigurationErrorType(MetricFailureToCreateFilterUnexpectedValue);
        /// <summary> Filter failed to create unexpectedly. </summary>
        public static CollectionConfigurationErrorType FilterFailureToCreateUnexpected { get; } = new CollectionConfigurationErrorType(FilterFailureToCreateUnexpectedValue);
        /// <summary> Collection configuration failed to create unexpectedly. </summary>
        public static CollectionConfigurationErrorType CollectionConfigurationFailureToCreateUnexpected { get; } = new CollectionConfigurationErrorType(CollectionConfigurationFailureToCreateUnexpectedValue);
        /// <summary> Determines if two <see cref="CollectionConfigurationErrorType"/> values are the same. </summary>
        public static bool operator ==(CollectionConfigurationErrorType left, CollectionConfigurationErrorType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CollectionConfigurationErrorType"/> values are not the same. </summary>
        public static bool operator !=(CollectionConfigurationErrorType left, CollectionConfigurationErrorType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CollectionConfigurationErrorType"/>. </summary>
        public static implicit operator CollectionConfigurationErrorType(string value) => new CollectionConfigurationErrorType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CollectionConfigurationErrorType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CollectionConfigurationErrorType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
