// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MongoCluster.Models
{
    /// <summary> The state of the replication link between the replica and source cluster. </summary>
    public readonly partial struct MongoClusterReplicationState : IEquatable<MongoClusterReplicationState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MongoClusterReplicationState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MongoClusterReplicationState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string CatchupValue = "Catchup";
        private const string ProvisioningValue = "Provisioning";
        private const string UpdatingValue = "Updating";
        private const string BrokenValue = "Broken";
        private const string ReconfiguringValue = "Reconfiguring";

        /// <summary> Replication link is active. </summary>
        public static MongoClusterReplicationState Active { get; } = new MongoClusterReplicationState(ActiveValue);
        /// <summary> Replica is catching-up with the primary. This can occur after the replica is created or after a promotion is triggered. </summary>
        public static MongoClusterReplicationState Catchup { get; } = new MongoClusterReplicationState(CatchupValue);
        /// <summary> Replica and replication link to the primary is being created. </summary>
        public static MongoClusterReplicationState Provisioning { get; } = new MongoClusterReplicationState(ProvisioningValue);
        /// <summary> Replication link is being updated due to a change on the replica or an upgrade. </summary>
        public static MongoClusterReplicationState Updating { get; } = new MongoClusterReplicationState(UpdatingValue);
        /// <summary> Replication link is broken and the replica may need to be recreated. </summary>
        public static MongoClusterReplicationState Broken { get; } = new MongoClusterReplicationState(BrokenValue);
        /// <summary> Replication link is re-configuring due to a promotion event. </summary>
        public static MongoClusterReplicationState Reconfiguring { get; } = new MongoClusterReplicationState(ReconfiguringValue);
        /// <summary> Determines if two <see cref="MongoClusterReplicationState"/> values are the same. </summary>
        public static bool operator ==(MongoClusterReplicationState left, MongoClusterReplicationState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MongoClusterReplicationState"/> values are not the same. </summary>
        public static bool operator !=(MongoClusterReplicationState left, MongoClusterReplicationState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MongoClusterReplicationState"/>. </summary>
        public static implicit operator MongoClusterReplicationState(string value) => new MongoClusterReplicationState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MongoClusterReplicationState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MongoClusterReplicationState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
