// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MongoCluster.Models
{
    /// <summary> The option to apply to a promote operation. </summary>
    public readonly partial struct MongoClusterPromoteOption : IEquatable<MongoClusterPromoteOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MongoClusterPromoteOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MongoClusterPromoteOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ForcedValue = "Forced";

        /// <summary> Promote option forces the promotion without waiting for the replica to be caught up to the primary. This can result in data-loss so should only be used during disaster recovery scenarios. </summary>
        public static MongoClusterPromoteOption Forced { get; } = new MongoClusterPromoteOption(ForcedValue);
        /// <summary> Determines if two <see cref="MongoClusterPromoteOption"/> values are the same. </summary>
        public static bool operator ==(MongoClusterPromoteOption left, MongoClusterPromoteOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MongoClusterPromoteOption"/> values are not the same. </summary>
        public static bool operator !=(MongoClusterPromoteOption left, MongoClusterPromoteOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MongoClusterPromoteOption"/>. </summary>
        public static implicit operator MongoClusterPromoteOption(string value) => new MongoClusterPromoteOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MongoClusterPromoteOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MongoClusterPromoteOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
