// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MongoCluster.Models
{
    /// <summary> The mode to apply to a promote operation. </summary>
    public readonly partial struct MongoClusterPromoteMode : IEquatable<MongoClusterPromoteMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MongoClusterPromoteMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MongoClusterPromoteMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SwitchoverValue = "Switchover";

        /// <summary> Promotion will switch the current replica cluster to the primary role and the original primary will be switched to a replica role, maintaining the replication link. </summary>
        public static MongoClusterPromoteMode Switchover { get; } = new MongoClusterPromoteMode(SwitchoverValue);
        /// <summary> Determines if two <see cref="MongoClusterPromoteMode"/> values are the same. </summary>
        public static bool operator ==(MongoClusterPromoteMode left, MongoClusterPromoteMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MongoClusterPromoteMode"/> values are not the same. </summary>
        public static bool operator !=(MongoClusterPromoteMode left, MongoClusterPromoteMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MongoClusterPromoteMode"/>. </summary>
        public static implicit operator MongoClusterPromoteMode(string value) => new MongoClusterPromoteMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MongoClusterPromoteMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MongoClusterPromoteMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
