// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MongoCluster.Models
{
    /// <summary> Preview features that can be enabled on a mongo cluster. </summary>
    public readonly partial struct MongoClusterPreviewFeature : IEquatable<MongoClusterPreviewFeature>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MongoClusterPreviewFeature"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MongoClusterPreviewFeature(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GeoReplicasValue = "GeoReplicas";

        /// <summary> Enables geo replicas preview feature. The feature must be set at create-time on new cluster to enable linking a geo-replica cluster to it. </summary>
        public static MongoClusterPreviewFeature GeoReplicas { get; } = new MongoClusterPreviewFeature(GeoReplicasValue);
        /// <summary> Determines if two <see cref="MongoClusterPreviewFeature"/> values are the same. </summary>
        public static bool operator ==(MongoClusterPreviewFeature left, MongoClusterPreviewFeature right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MongoClusterPreviewFeature"/> values are not the same. </summary>
        public static bool operator !=(MongoClusterPreviewFeature left, MongoClusterPreviewFeature right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MongoClusterPreviewFeature"/>. </summary>
        public static implicit operator MongoClusterPreviewFeature(string value) => new MongoClusterPreviewFeature(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MongoClusterPreviewFeature other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MongoClusterPreviewFeature other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
