// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.MongoCluster.Models
{
    /// <summary> The high availability modes for a cluster. </summary>
    public readonly partial struct HighAvailabilityMode : IEquatable<HighAvailabilityMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HighAvailabilityMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HighAvailabilityMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string SameZoneValue = "SameZone";
        private const string ZoneRedundantPreferredValue = "ZoneRedundantPreferred";

        /// <summary> High availability mode is disabled. This mode is can see availability impact during faults or maintenance and is not recommended for production. </summary>
        public static HighAvailabilityMode Disabled { get; } = new HighAvailabilityMode(DisabledValue);
        /// <summary> High availability mode is enabled, where each server in a shard is placed in the same availability zone. </summary>
        public static HighAvailabilityMode SameZone { get; } = new HighAvailabilityMode(SameZoneValue);
        /// <summary> High availability mode is enabled and preferences ZoneRedundant if availability zones capacity is available in the region, otherwise falls-back to provisioning with SameZone. </summary>
        public static HighAvailabilityMode ZoneRedundantPreferred { get; } = new HighAvailabilityMode(ZoneRedundantPreferredValue);
        /// <summary> Determines if two <see cref="HighAvailabilityMode"/> values are the same. </summary>
        public static bool operator ==(HighAvailabilityMode left, HighAvailabilityMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HighAvailabilityMode"/> values are not the same. </summary>
        public static bool operator !=(HighAvailabilityMode left, HighAvailabilityMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HighAvailabilityMode"/>. </summary>
        public static implicit operator HighAvailabilityMode(string value) => new HighAvailabilityMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HighAvailabilityMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HighAvailabilityMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
