// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.MongoCluster
{
    internal class MongoClusterPrivateEndpointConnectionResourceOperationSource : IOperationSource<MongoClusterPrivateEndpointConnectionResource>
    {
        private readonly ArmClient _client;

        internal MongoClusterPrivateEndpointConnectionResourceOperationSource(ArmClient client)
        {
            _client = client;
        }

        MongoClusterPrivateEndpointConnectionResource IOperationSource<MongoClusterPrivateEndpointConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MongoClusterPrivateEndpointConnectionResourceData.DeserializeMongoClusterPrivateEndpointConnectionResourceData(document.RootElement);
            return new MongoClusterPrivateEndpointConnectionResource(_client, data);
        }

        async ValueTask<MongoClusterPrivateEndpointConnectionResource> IOperationSource<MongoClusterPrivateEndpointConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MongoClusterPrivateEndpointConnectionResourceData.DeserializeMongoClusterPrivateEndpointConnectionResourceData(document.RootElement);
            return new MongoClusterPrivateEndpointConnectionResource(_client, data);
        }
    }
}
